#include <iostream>
#include <stack>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    ios::bas

    int n;
    cin >> n;

    vector<pair<long long,long long>> v(n); 

    for(int i = 0; i < n; i++)
        cin >> v[i].first;
    for(int i = 0; i < n; i++)
        cin >> v[i].second;

    vector<int> order(n);
    for(int i = 0; i < n; i++) order[i] = i;

    sort(order.begin(), order.end(), [&](int a, int b){
        return v[a].first < v[b].first;
    });

    vector<pair<long long,long long>> sv(n);
    for(int i = 0; i < n; i++)
        sv[i] = v[order[i]];

    vector<int> NGL(n), NGR(n);

    stack<int> st;
    NGL[0] = -1;
    st.push(0);
    for(int i = 1; i < n; i++) {
        while(!st.empty() && sv[st.top()].second <= sv[i].second)
            st.pop();
        NGL[i] = (st.empty() ? -1 : st.top());
        st.push(i);
    }

    while(!st.empty()) st.pop();
    NGR[n-1] = -1;
    st.push(n-1);
    for(int i = n-2; i >= 0; i--) {
        while(!st.empty() && sv[st.top()].second <= sv[i].second)
            st.pop();
        NGR[i] = (st.empty() ? -1 : st.top());
        st.push(i);
    }

    vector<long long> res(n);
    long long INF = 1e18;
    for(int i = 0; i < n; i++) {
        long long d = INF, l = INF;

        if(NGR[i] != -1)
            d = (sv[NGR[i]].first - sv[NGR[i]].second + sv[i].second) - sv[i].first;

        if(NGL[i] != -1)
            l = sv[i].first - (sv[NGL[i]].first + sv[NGL[i]].second - sv[i].second);

        res[i] = min(d, l);
    }
    vector<long long> final_res(n, -1);
    for(int i = 0; i < n; i++) {
        int orig = order[i];
        if(res[i] >= INF) final_res[orig] = -1;
        else final_res[orig] = res[i];
    }

    for(int i = 0; i < n; i++)
        cout << final_res[i] << endl;
}